/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Locale;

public class UIObjectProperties
implements UIObjectsConstants {
    protected static String BAD_BUFFER = "The buffer argument is null or is not the correct length.";
    private static final String TRACE_MASKT = "HUIOBJPT";
    private static final String TRACE_MASKF = "HUIOBJPF";
    private static final String TRACE_MASKD = "HUIOBJPD";

    public static String getShortId(byte[] buffer) {
        String result = new String(buffer, 0, 8).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getShortId() returning null");
        }
        return result;
    }

    public static LocalizableText getName(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        LocalizableText result = null;
        String key = new String(buffer, 200, 80).trim();
        if (key.length() > 0) {
            String res = new String(buffer, 120, 80).trim();
            result = res.length() > 0 ? new LocalizableText(res, key) : new LocalizableText(key);
        }
        if (result == null) {
            Trace.trace(TRACE_MASKF, "getName() returning null");
        }
        return result;
    }

    public static String getLocalizedName(byte[] buffer, Locale locale) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = null;
        LocalizableText text = UIObjectProperties.getName(buffer);
        if (text == null) {
            Trace.trace(TRACE_MASKF, "getLocalizedName() returning null");
        } else {
            result = text.toString(locale);
        }
        return result;
    }

    public static String getNameKey(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 200, 80).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getNameKey() returning null");
        }
        return result;
    }

    public static LocalizableText getCaption(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        LocalizableText result = null;
        String key = new String(buffer, 680, 80).trim();
        if (key.length() > 0) {
            String res = new String(buffer, 600, 80).trim();
            result = res.length() > 0 ? new LocalizableText(res, key) : new LocalizableText(key);
        }
        if (result == null) {
            Trace.trace(TRACE_MASKF, "getCaption() returning null");
        }
        return result;
    }

    public static String getLocalizedCaption(byte[] buffer, Locale locale) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = null;
        LocalizableText text = UIObjectProperties.getCaption(buffer);
        if (text == null) {
            Trace.trace(TRACE_MASKF, "getLocalizedCaption() returning null");
        } else {
            result = text.toString(locale);
        }
        return result;
    }

    public static String getCaptionKey(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 680, 80).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getCaptionKey() returning null");
        }
        return result;
    }

    public static String getObjectIdNameKey(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 440, 80).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getObjectIdNameKey() returning null for shortId " + UIObjectProperties.getShortId(buffer));
        }
        return result;
    }

    public static LocalizableText getStatusText(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        LocalizableText result = null;
        String key = new String(buffer, 360, 80).trim();
        if (key.length() > 0) {
            String res = new String(buffer, 280, 80).trim();
            result = res.length() > 0 ? new LocalizableText(res, key) : new LocalizableText(key);
        }
        if (result == null) {
            Trace.trace(TRACE_MASKF, "getStatusText() returning null");
        }
        return result;
    }

    public static String getLocalizedStatusText(byte[] buffer, Locale locale) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = null;
        LocalizableText text = UIObjectProperties.getStatusText(buffer);
        if (text == null) {
            Trace.trace(TRACE_MASKF, "getLocalizedStatusText() returning null");
        } else {
            result = text.toString(locale);
        }
        return result;
    }

    public static String getStatusShortId(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 16, 8).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getStatusShortId() returning null");
        }
        return result;
    }

    public static String getImageName(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 40, 80).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getImageName() returning null");
        }
        return result;
    }

    public static String getMergedKey(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 520, 80).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getMergedKey() returning null");
        }
        return result;
    }

    public static boolean isStatusAcceptable(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[12] == 84;
    }

    public static boolean isRoot(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[11] == 84;
    }

    public static boolean isBusy(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[10] == 84;
    }

    public static boolean isLocked(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[13] == 84;
    }

    public static boolean isTargetRequired(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[15] == 84;
    }

    public static boolean attentionsExist(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[14] == 84;
    }

    public static String getAttentionTaskShortId(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 24, 8).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getStatusText() returning null");
        }
        return result;
    }

    public static boolean isDeleted(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[8] == 84;
    }

    public static byte getType(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[9];
    }

    public static String getClassTypeShortId(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        String result = new String(buffer, 32, 8).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getClassTypeShortId() returning null");
        }
        return result;
    }

    public static String getOpenTaskShortId(byte[] buffer) {
        String result = new String(buffer, 760, 8).trim();
        if (result.length() == 0) {
            result = null;
            Trace.trace(TRACE_MASKF, "getOpenTaskShortId() returning null");
        }
        return result;
    }

    public static boolean isManagedObject(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isManagedObject(buffer[9]);
    }

    public static boolean isManagedObject(byte b) {
        return b == 49 || b == 55;
    }

    public static boolean isConsoleManagedObject(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isConsoleManagedObject(buffer[9]);
    }

    public static boolean isConsoleManagedObject(byte b) {
        return b == 55;
    }

    public static boolean isTask(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isTask(buffer[9]);
    }

    public static boolean isTask(byte b) {
        return b == 51;
    }

    public static boolean isManagedObjectGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isManagedObjectGroup(buffer[9]);
    }

    public static boolean isManagedObjectGroup(byte b) {
        return b == 50 || UIObjectProperties.isCustomizedManagedObjectGroup(b);
    }

    public static boolean isCustomizedManagedObjectGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isCustomizedManagedObjectGroup(buffer[9]);
    }

    public static boolean isCustomizedManagedObjectGroup(byte b) {
        return b == 56;
    }

    public static boolean isTaskGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isTaskGroup(buffer[9]);
    }

    public static boolean isTaskGroup(byte b) {
        return b == 52 || UIObjectProperties.isConsoleTaskGroup(b) || UIObjectProperties.isCustomizedTaskGroup(b);
    }

    public static boolean isConsoleTaskGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isConsoleTaskGroup(buffer[9]);
    }

    public static boolean isConsoleTaskGroup(byte b) {
        return b == 53 || UIObjectProperties.isCustomizedConsoleTaskGroup(b);
    }

    public static boolean isCustomizedTaskGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isCustomizedTaskGroup(buffer[9]);
    }

    public static boolean isCustomizedTaskGroup(byte b) {
        return b == 54;
    }

    public static boolean isCustomizedConsoleTaskGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isCustomizedConsoleTaskGroup(buffer[9]);
    }

    public static boolean isCustomizedConsoleTaskGroup(byte b) {
        return b == 57;
    }

    public static boolean isGroup(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return UIObjectProperties.isManagedObjectGroup(buffer) || UIObjectProperties.isTaskGroup(buffer);
    }

    public static boolean isGroup(byte b) {
        return UIObjectProperties.isManagedObjectGroup(b) || UIObjectProperties.isTaskGroup(b);
    }

    public static boolean isMatchingType(byte[] buffer, byte type) {
        boolean result = false;
        switch (type) {
            case 52: {
                result = UIObjectProperties.isTaskGroup(buffer);
                break;
            }
            case 53: {
                result = UIObjectProperties.isConsoleTaskGroup(buffer);
                break;
            }
            case 50: {
                result = UIObjectProperties.isManagedObjectGroup(buffer);
                break;
            }
            case 54: {
                result = UIObjectProperties.isCustomizedTaskGroup(buffer);
                break;
            }
            case 56: {
                result = UIObjectProperties.isCustomizedManagedObjectGroup(buffer);
                break;
            }
            case 49: {
                result = UIObjectProperties.isManagedObject(buffer);
                break;
            }
            case 55: {
                result = UIObjectProperties.isConsoleManagedObject(buffer);
                break;
            }
            case 51: {
                result = UIObjectProperties.isTask(buffer);
            }
        }
        return result;
    }

    public static boolean isDisruptive(byte[] buffer) {
        if (buffer == null || buffer.length < 770) {
            throw new IllegalArgumentException(BAD_BUFFER);
        }
        return buffer[768] == 84;
    }
}

